<?php

namespace App\Http\Controllers;

//use App\Models\Admin;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Hash;
use DB;
use Mail;
class FrontController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


  // Use for show  home page 
   public function showHomePage()
   {
      $feeds ='';
      
      $ads = DB::table('front_page')->where('id',6)->first();  
     
      $feeds =DB::table('feeds')->where('type',1)->orderByDesc('post_date')->limit(5)->get();
      return view('pages.front.home',['ads'=>$ads,'feeds'=>$feeds]);
  
   
   }


  // Use for show  Forex page 
   public function showForexPage()
   {
      $market_news=''; 
      $ads = DB::table('front_page')->where('id',6)->first();  
  
      //$market_url ='https://api.rss2json.com/v1/api.json?rss_url=https://www.dailyfx.com/feeds/market-news';
      //$market_news =self::getMarketNews($market_url);
       $market_news =DB::table('feeds')->where('type',2)->orderByDesc('post_date')->limit(5)->get();
     
      return view('pages.front.forex',['ads'=>$ads,'market_news'=>$market_news]);
   
   }


  // Use for show  length page 
   public function showLengthPage()
   {
      $feeds ='';
     
      $ads = DB::table('front_page')->where('id',6)->first();  
    //  $url='https://analysis.hotforex.com/feed/';
      //$feeds =self::getFeed($url);
       $feeds =DB::table('feeds')->where('type',1)->orderByDesc('post_date')->limit(5)->get();
     
       return view('pages.front.length',['ads'=>$ads,'feeds'=>$feeds]);
   
   }

  // Use for show  volume page 
   public function showVolumePage()
   {
      $feeds ='';
     
      $ads = DB::table('front_page')->where('id',6)->first();  
     // $url='https://analysis.hotforex.com/feed/';
      //$feeds =self::getFeed($url);
       $feeds =DB::table('feeds')->where('type',1)->orderByDesc('post_date')->limit(5)->get();
     
      return view('pages.front.volume',['ads'=>$ads,'feeds'=>$feeds]);
   
   }


  // Use for show  weight page 
   public function showWeightPage()
   {
      $feeds ='';
   
      $ads = DB::table('front_page')->where('id',6)->first();  
     // $url='https://analysis.hotforex.com/feed/';
     // $feeds =self::getFeed($url);
      $feeds =DB::table('feeds')->where('type',1)->orderByDesc('post_date')->limit(5)->get();
     
     return view('pages.front.weight',['ads'=>$ads,'feeds'=>$feeds]);
   
   }


  // Use for show  area page 
   public function showAreaPage()
   {
      $feeds ='';
      $ads = DB::table('front_page')->where('id',6)->first();  
      //$url='https://analysis.hotforex.com/feed/';
     // $feeds =self::getFeed($url);
      $feeds =DB::table('feeds')->where('type',1)->orderByDesc('post_date')->limit(5)->get();
     
      return view('pages.front.area',['ads'=>$ads,'feeds'=>$feeds]);
   
   }


  // Use for show speed page 
   public function showSpeedPage()
   {
      $feeds ='';
  
      $ads = DB::table('front_page')->where('id',6)->first();  
      //$url='https://analysis.hotforex.com/feed/';
     // $feeds =self::getFeed($url);
      $feeds =DB::table('feeds')->where('type',1)->orderByDesc('post_date')->limit(5)->get();
     
     return view('pages.front.speed',['ads'=>$ads,'feeds'=>$feeds]);
   
   }


  


  // Use for show about page content
   public function showAboutPage()
   {
     
      $aboutus =  DB::table('front_page')->where('id',1)->first();
        $ads = DB::table('front_page')->where('id',6)->first();       
      return view('pages.front.about',['aboutus'=>$aboutus,'ads'=>$ads]);
   
   }

  // Use for show dcma copyright page content
  public function showDcmaPage()
   {
     $dcma =  DB::table('front_page')->where('id',2)->first();
      $ads = DB::table('front_page')->where('id',6)->first();           
      return view('pages.front.copyright',['dcma'=>$dcma,'ads'=>$ads]);

   }

// Use for show privacy policy page content
   public function showPrivacyPage()
   {
     $privacy =  DB::table('front_page')->where('id',3)->first();
      $ads = DB::table('front_page')->where('id',6)->first();           
      return view('pages.front.privacy',['privacy'=>$privacy,'ads'=>$ads]);

   }

// Use for show terms and conditions page content
   public function showTermsPage()
   {
     $terms =  DB::table('front_page')->where('id',4)->first();
      $ads = DB::table('front_page')->where('id',6)->first();           
      return view('pages.front.termsconditions',['terms'=>$terms,'ads'=>$ads]);

   }


   // Use for show contact page content
   public function showContactPage()
   {
     
      $ads = DB::table('front_page')->where('id',6)->first();       
      $contact = DB::table('front_page')->where('id',7)->first();       
      
      return view('pages.front.contact',['ads'=>$ads,'contact'=>$contact]);
   
   }


  // Use for post contact data
   public function postContactData(Request $request)
   {

       $validator = Validator::make($request->all(), [
          'name'          => 'required',
          'email'         => 'required|email',
          'subject' => 'required',
          'message'       => 'required'
      ]);

     
     if ($validator->passes())
     {

           

             $contact = DB::table('front_page')->where('id',7)->first();       
    
             $to = $contact->email;
             $subject = $request->subject;
             $name = $request->name;
             $email= $request->email;
             $message= $request->message;
             
             $from = "info@technopoint.website";
           
             $maildata = array('name'=>$name,'email'=>$email,'subject'=>$subject,'content'=>$message);
             $data= array('name'=>$request->name,'email'=>$request->email,'subject'=>$request->subject,'message'=>$request->message,'created_at'=>date('Y-m-d H:i:s'));
               DB::table('contact')->insert($data);
                
              Mail::send(['html' => 'pages.sent_mail'], $maildata, function($message) use ($to, $subject,$from,$name) 
              {
            
                 $message->to($to, 'ConvertXp Mail')->subject($subject);
                 $message->from($from,'ConvertXp');
                  
                 return response()->json(['success'=>'Your message has been sent. Thank you!.']);
   
                
             });
            
              
    }

        return response()->json(['error'=>$validator->errors()]);
      


   }



  public function getConvert(Request $request)
  {
        $api_key = DB::table('front_page')->where('id',5)->first();       
    
        $amount = $request->amount;
        $from_type =$request->from_type;
        $to_type =$request->to_type;
        $ctype=$request->ctype;
      
         $curl = curl_init();

          curl_setopt_array($curl, [
          CURLOPT_URL => "https://community-neutrino-currency-conversion.p.rapidapi.com/convert",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => "from-type=".$from_type."&to-type=".$to_type."&from-value=".$amount,
          CURLOPT_HTTPHEADER => [
            "content-type: application/x-www-form-urlencoded",
            "x-rapidapi-host: community-neutrino-currency-conversion.p.rapidapi.com",
            "x-rapidapi-key: ".$api_key->api_key.""

          ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE); 
        curl_close($curl);




        if ($err) 
        {
          //echo "cURL Error #:" . $err;
           return response(['error'=>$err]);
      
        } 
        else 
        {
          //echo $response;
            
            $result = json_decode($response,true);

            if($httpcode==200)
            {
               if($result['valid']==1)
               {
               
                    $tbfrontpage = DB::table('front_page')->where('id',8)->first();
                    $total=0;
                    if(!empty($tbfrontpage))
                    {
                        $total = $tbfrontpage->total;
                        $total =$total+1;
                         DB::table('front_page')->where('id',8)->update(array('total'=>$total));
                    }
                $convert_amount = $result['result'];   
                $convert_amount = number_format($convert_amount, 2);      
            
                 return response()->json(['status'=>200,'valid'=>$result['valid'],'convert_amount'=>$convert_amount,'to_type'=>$result['to-type'],'ctype'=>$ctype,'amount'=>$result['from-value'],'from_type'=>$result['from-type']]);
               }
               else
               {
                 return response()->json(['status'=>200,'error'=>'NA','ctype'=>$ctype,'vaild'=>0]);
               }
             }
             else
             {

                 return response()->json(['status'=>201,'error'=>'DAILY API LIMIT EXCEEDED']);
              
             }
           

       }
        
  }



// Get Feed from website
/*
 public function getFeed($url){

  if(@simplexml_load_file($url)){
  $feeds = simplexml_load_file($url);
  return $feeds;

 }

 }*/


 // Post Feed in database
 public function postFeed()
 {
   $url='https://analysis.hotforex.com/feed/';
   if(@simplexml_load_file($url))
   {
      $feeds = simplexml_load_file($url);
      $i=0;
     if(!empty($feeds))
     {
       $sitelink = $feeds->channel->link;
       foreach ($feeds->channel->item as $item) 
       {
          $image = $feeds->channel->item[$i]->children('media', True)->content->attributes()['url'];
          $title = $item->title;
          $slug = self::slugify($title);
          $description= $item->description;
          $post_date = date('Y-m-d H:i:s',strtotime($item->pubDate));
          $e_content     = $item->children("content", true);
          $content     = (string)$e_content->encoded;
        
        $tbfeed =DB::table('feeds')->where('title',$title)->where('type',1)->first();

        if(!$tbfeed)
        {
          DB::table('feeds')->insert(array('title'=>$title,'slug'=>$slug,'image'=>$sitelink.$image,'site_url'=>$sitelink,'description'=>$description,'content'=>$content,'type'=>1,'post_date'=>$post_date));
        }
     $i++;
  }
 }

}

 }




 // Post Market Feed in database
 public function postMarketFeed()
 {
   $url='https://www.forexmt4indicators.com/feed/';
   if(@simplexml_load_file($url))
   {
      $feeds = simplexml_load_file($url);
      $i=0;
     if(!empty($feeds))
     {
      $sitelink = $feeds->channel->link;
       foreach ($feeds->channel->item as $item) 
       {
         
          $title = $item->title;
          $slug = self::slugify($title);
           $description= $item->description;
          $post_date = date('Y-m-d H:i:s',strtotime($item->pubDate));
          $e_content     = $item->children("content", true);
          $content     = (string)$e_content->encoded;
        
        $tbfeed =DB::table('feeds')->where('title',$title)->where('type',2)->first();

        if(!$tbfeed)
        {
          DB::table('feeds')->insert(array('title'=>$title,'slug'=>$slug,'site_url'=>$sitelink,'description'=>$description,'content'=>$content,'type'=>2,'post_date'=>$post_date));
        }
        $i++;
       }
     }

    }

 }



 

public function slugify($string){
        return strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $string), '-'));
}





  public function getMarketNews($url)
 {


  //  Initiate curl
  $ch = curl_init();
  // Will return the response, if false it print the response
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  // Set the url
  curl_setopt($ch, CURLOPT_URL,$url);
  // Execute
  $response=curl_exec($ch);
  $err = curl_error($ch);
  $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE); 
  // Closing
  curl_close($ch);

  // Will dump a beauty json :3
  if($httpcode==200)
  {
      return json_decode($response, true);
         
  }
 

 }


// Single Recent News Page 
public function recentNewsPage(Request $request,$id)
{

    $feeds=DB::table('feeds')->where('slug',$id)->first();
    $ads = DB::table('front_page')->where('id',6)->first();       
    return view('pages.front.recentNews',['ads'=>$ads,'feeds'=>$feeds]);

}

// Show Blog List
public function showBlogPage(Request $request)
{

    $ads = DB::table('front_page')->where('id',6)->first(); 
   $feeds = DB::table('feeds')->orderBy('post_date', 'DESC')->simplePaginate(10);
    
    return view('pages.front.blog', ['ads'=>$ads,'feeds' => $feeds]);
}
 
}
