@extends('layouts.adminapp')
@section('title') @parent @endsection
@section('content')

                        <div class="page-title-box">
                            <div class="row align-items-center">
                                <div class="col-sm-6">
                                    <h4 class="page-title">Edit Feed</h4>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end page-title -->

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card m-b-30">
                                    <div class="card-body">
                                         @if(Session::has('success'))
                            <div class="alert alert-success alert-dismissible col-md-6">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                {{Session::get('success')}}
                            </div>
                        @elseif(Session::has('failed'))
                            <div class="alert alert-danger alert-dismissible col-md-6">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                {{Session::get('failed')}}
                            </div>
                        @endif
                                      
                                        <form class="" action="<?php echo URL::to('/admin/updateFeed'); ?>" method="post" enctype="multipart/form-data">
                                            <input type="hidden" name="_token" value="<?php echo csrf_token(); ?>">
                                            <input type="hidden" name="id" value="<?php echo $feeds->id; ?>">
                                           
                                            <div class="form-row">
                                                 <div class="form-group col-md-3">
                                                     <label>Title</label>

                                                     <input type="text" name='title' class="form-control" value="<?php echo $feeds->title; ?>" />
                                                      {!!$errors->first("title", "<span class='text-danger'>:message</span>")!!}
                                                 </div>
                                                <div class="form-group col-md-3">
                                                     <label>Image</label>

                                                     <input type="file" name='image' accept="image/*"><br/><b style="color:red;">* Only jpeg, jpg, png extension allowed.</b>
                                                     
                                                 </div>
                                                <div class="form-group col-md-3">
                                                     <label>Old Image</label><br/>
                                                     <img src="<?php echo $feeds->image;?>" height="100">
                                                    
                                                     
                                                 </div>

                                            </div>
                                            <div class="form-row">
                                                 <div class="form-group col-md-6">
                                                     <label>Description</label>
                                                     <textarea id="feed-description-page" name="description"><?php echo $feeds->description; ?></textarea>
                                                     {!!$errors->first("description", "<span class='text-danger'>:message</span>")!!}
                                                 </div>
                                                 <div class="form-group col-md-6">
                                                     <label>Content</label>
                                                     <textarea id="feed-page" name="content"><?php echo $feeds->content; ?></textarea>
                                                     {!!$errors->first("content", "<span class='text-danger'>:message</span>")!!}
                                                 </div>
                                            </div>
        
                                            <div class="form-group">
                                                <div>
                                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                        Submit
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
        
                                    </div>
                                </div>
                            </div> <!-- end col -->
        
                          
                        </div> <!-- end row -->      

                        
@endsection  