<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\FrontController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/', function () {
    return view('pages/front/home');
});*/


Route::get('/', [FrontController::class, 'showHomePage']);
Route::get('/about', [FrontController::class, 'showAboutPage']);
Route::get('/contact',[FrontController::class, 'showContactPage']);
Route::get('/forex',[FrontController::class, 'showForexPage']);
Route::get('/length',[FrontController::class, 'showLengthPage']);
Route::get('/volume',[FrontController::class, 'showVolumePage']);
Route::get('/mass',[FrontController::class, 'showWeightPage']);
Route::get('/area',[FrontController::class, 'showAreaPage']);
Route::get('/speed',[FrontController::class, 'showSpeedPage']);

Route::get('/copyright',[FrontController::class, 'showDcmaPage']);
Route::get('/privacy',[FrontController::class, 'showPrivacyPage']);
Route::get('/termsconditions',[FrontController::class, 'showTermsPage']);
Route::post('/postContact',[FrontController::class, 'postContactData']);

Route::get('/getConvert',[FrontController::class, 'getConvert']);

Route::get('/getFeed',[FrontController::class, 'postFeed']);
Route::get('/getMarketFeed',[FrontController::class, 'postMarketFeed']);
Route::get('/recentnews/{id}',[FrontController::class, 'recentNewsPage']);
Route::get('/news',[FrontController::class, 'showBlogPage']); 

/*Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
    return view('dashboard');
})->name('dashboard');*/

Route::group(['middleware' => ['auth:sanctum', 'verified']], function()
{
   /*Route::get('/admin/dashboard', function()
   	{  
   		return view('dashboard');
   	})->name('dashboard');*/
  Route::get('/admin/dashboard',[AdminController::class, 'showDashboardPage']);
 
  Route::get('/admin/changepassword',[AdminController::class, 'showChangePassword']);
  Route::post('/admin/updatePassword',[AdminController::class, 'updatePassword']);
  Route::get('/admin/aboutus',[AdminController::class, 'showAboutPage']);
  Route::get('/admin/contact',[AdminController::class, 'showContactPage']);
  Route::get('/admin/dcma',[AdminController::class, 'showDcmaPage']);
  Route::get('/admin/privacypolicy',[AdminController::class, 'showPrivacyPolicyPage']);
  Route::get('/admin/terms',[AdminController::class, 'showTermsPage']);
  Route::post('/admin/uploadimage',[AdminController::class, 'uploadImage']);
  Route::post('/admin/updateAbout',[AdminController::class, 'updateAboutPage']);
  Route::post('/admin/updateContact',[AdminController::class, 'updateContactPage']);
 
  Route::post('/admin/updateDcma',[AdminController::class, 'updateDcmaPage']);
  Route::post('/admin/updatePrivacy',[AdminController::class, 'updatePrivacyPage']);
  Route::post('/admin/updateTerms',[AdminController::class, 'updateTermsPage']);
  Route::get('/admin/apiKey',[AdminController::class, 'showApiKeyPage']);
  Route::post('/admin/updateApiKey',[AdminController::class, 'updateApiKeyPage']);
  Route::get('/admin/headerAds',[AdminController::class, 'showHeaderAdsPage']);
  Route::post('/admin/updateHeaderAds',[AdminController::class, 'updateHeaderAdsPage']);
  Route::get('/admin/footerAds',[AdminController::class, 'showFooterAdsPage']);
  Route::post('/admin/updateFooterAds',[AdminController::class, 'updateFooterAdsPage']);
   Route::get('/admin/leftAds',[AdminController::class, 'showLeftAdsPage']);
  Route::post('/admin/updateLeftAds',[AdminController::class, 'updateLeftAdsPage']);
   Route::get('/admin/rightAds',[AdminController::class, 'showRightAdsPage']);
  Route::post('/admin/updateRightAds',[AdminController::class, 'updateRightAdsPage']);
  Route::get('/admin/headSection',[AdminController::class, 'showHeadSectionPage']);
  Route::post('/admin/updateHeadSection',[AdminController::class, 'updateHeadSectionPage']);


  Route::get('/admin/contactList',[AdminController::class, 'showContactListPage']);
  Route::post('/admin/deleteContact',[AdminController::class, 'deleteContact']);
  Route::get('/admin/editFeed/{id}',[AdminController::class, 'editFeedPage']);
  Route::post('/admin/updateFeed',[AdminController::class, 'updateFeedPage']);
  Route::get('/admin/feedList',[AdminController::class, 'showFeedListPage']);
  
  Route::post('/admin/deleteFeed',[AdminController::class, 'deleteFeed']);


 

});
